//
//  OPMasterController.m
//  The Obfuscated Path
//
//  Created by ss2cire on 2/16/09.
//  Copyright 2009 GryphonClaw Software. All rights reserved.
//

#import "OPMasterController.h"
#import "OPApplication.h"
#import "OPGameController.h"
#import "OPMenuController.h"

@implementation OPMasterController
- (id)init
{
	self = [super init];
	if(self != nil)
	{
		[NSApp setMasterController:self];
		[NSApp loadTileMap];
		[NSApp loadEnemyMap];

		menuController = [[OPMenuController alloc] init];
		gameController = [[OPGameController alloc] init];
		[NSApp setPlayer:[gameController player]];
		id test;
		test = [NSApp player];

		currentController = gameController;
	}
	return self;
}

- (void)draw
{
	[(OPModeController *)currentController draw];
}

- (void)update
{
	[(OPModeController *)currentController update];
}

- (void)setCurrentController:(OPModeController *)controller
{
	currentController = controller;
}

- (id)currentController
{
	return currentController;
}

- (void)keyDown:(NSEvent *)event
{
	[currentController keyDown:event];
}

- (void)keyUp:(NSEvent *)event
{
	[currentController keyUp:event];
}

- (void)mouseDown:(NSEvent *)event
{
	[currentController mouseDown:event];
}

- (void)mouseUp:(NSEvent *)event
{
	[currentController mouseUp:event];
}

- (void)mouseDragged:(NSEvent *)event
{
	[currentController mouseDragged:event];
}

- (void)mouseMoved:(NSEvent *)event
{
	[currentController mouseMoved:event];
}

- (OPMenuController	*)menuController
{
	return menuController;
}

- (OPGameController	*)gameController
{
	return gameController;
}

@end
